package netsdk.struct;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;

public class NET_SDK_REC_TIME extends Structure{

	public NET_SDK_REC_TIME(Pointer p) {
		super(p,ALIGN_NONE);
		useMemory(p);
		read();
	}
	public NET_SDK_REC_TIME() {
		super(ALIGN_NONE);
	}

	public static class ByReference extends NET_SDK_REC_TIME implements Structure.ByReference {
	}

	public static class ByValue extends NET_SDK_REC_TIME implements Structure.ByValue {
	}
	public int dwChannel;//通道号	
	public DD_TIME startTime;//该段录像开始时间
	public DD_TIME stopTime;//该段录像结束时间


	@Override
	protected List<String> getFieldOrder() {
		List<Field> flist = getFieldList();
		List<String> list = new ArrayList<>(flist.size());
		for (Field f : flist) {
		    list.add(f.getName());
		}
		return list;
	}
}
